//JavaScript Document

function calculRatioPC(){
	try{
	if($("pbi_proteinurie")==null) return;
	if($("pbi_creatininurie")==null) return;
	if($("pbi_proteinurie").value!="" && !isNaN($("pbi_proteinurie").value.replace(",", ".")) && !isNaN($("pbi_creatininurie").value.replace(",", ".")) && $("pbi_creatininurie").value!=""){
		$("pbi_ratio_proteinurie_creatininurie").value=new Number(($("pbi_proteinurie").value.replace(",", ".")/$("pbi_creatininurie").value.replace(",", "."))*1000).toFixed(1);
	}
	else{
		$("pbi_ratio_proteinurie_creatininurie").value="";
	}
	}
	catch(err){
		alert("Une erreur est survenue lors du calcul du paramtre Proetininurie/creatininurie");
	}
}

function calculFEUree(){
	try{
		if($("pbi_uree_urinaire")==null) return;
		uree_urinaire=$("pbi_uree_urinaire").value.replace(",", ".");

		if($("pbi_creatinine")==null) return;
		creatinine=$("pbi_creatinine").value.replace(",", ".");

		if($("pbi_uree")==null) return;
		uree=$("pbi_uree").value.replace(",", ".");

		if($("pbi_creatininurie")==null) return;
		creatininurie=$("pbi_creatininurie").value.replace(",", ".");

		if(checkNumber(uree_urinaire) && checkNumber(creatinine) && checkNumber(uree) && checkNumber(creatininurie)) {
			$("pbi_fe_uree").value=new Number(((uree_urinaire* creatinine) / (uree * creatininurie))/10).toFixed(2);
		}
		else{
			$("pbi_fe_uree").value="";
		}
	}
	catch(err){
		alert("Une erreur est survenue lors du calcul du paramtre FE Uree");
	}
}

function calculClairanceCockroft(age, sexe){
	try{
		if($("pbi_poids")==null) return;
		poids=$("pbi_poids").value.replace(",", ".");
		
		if($("pbi_creatinine")==null) return;
		creatinine=$("pbi_creatinine").value.replace(",", ".");

		k= (sexe==2 ? 1.04 : 1.23 );
		
		if(checkNumber(creatinine)){
			$("pbi_clairance_cockroft").value=new Number(((140-age)/creatinine)*poids*k).toFixed(1);
		}
		else{
			$("pbi_clairance_cockroft").value="";
		}
	}
	catch(err){
		alert("Une erreur est survenue lors du calcul du paramtre Clairance Cockroft : "+e.message);
	}
}

function calculFENA(){
	try{
		if($("pbi_natriurese")==null) return;
		natriurese=$("pbi_natriurese").value.replace(",", ".");

		if($("pbi_creatinine")==null) return;
		creatinine=$("pbi_creatinine").value.replace(",", ".");

		if($("pbi_sodium")==null) return;
		sodium=$("pbi_sodium").value.replace(",", ".");

		if($("pbi_creatininurie")==null) return;
		creatininurie=$("pbi_creatininurie").value.replace(",", ".");

		if(checkNumber(natriurese) && checkNumber(creatinine) && checkNumber(sodium) && checkNumber(creatininurie)) {
			$("pbi_fe_na").value=new Number(((natriurese* creatinine) / (sodium * creatininurie))/10).toFixed(2);
		}
		else{
			$("pbi_fe_na").value="";
		}
	}
	catch(err){
		alert("Une erreur est survenue lors du calcul du paramtre FE NA");
	}
}

function checkNumber(value){
	return value!='' && value!=null && !isNaN(value.replace(",", "."));
}

function getMedicamentInfo(file, medi_code){
	url = ROOT_HOST+file+'?obj=patient&action=medic_info&medi_code='+medi_code;
	mediInfo=new Array();

	var opt = {
			asynchronous: true, 
			evalScripts: true,
			dataType: "xml",
			onSuccess: function( t ) { 
				alert($(t).find($('medicament')));
			}
	}
	new Ajax.Request(url, opt);
}

function isMedicamentSubstituable(file, medi_code){
	url = ROOT_HOST+file+'?obj=patient&action=medic_substituable&medi_code='+medi_code;
	isSubstituable=true;
	var opt = {
			asynchronous: false, 
			evalScripts: true,
			onSuccess: function(response) { 
				isSubstituable=(1==response.responseText);
			}
	}
	new Ajax.Request(url, opt);
	return isSubstituable;
}

/**
 * Get Communes List by Pay
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function setPayCommunes(file, form_name, oblig, pay_code, com_code, width, onchange)
{
	url = ROOT_HOST+file+'?obj=ajax&action=set_pay_communes&pay_code='+pay_code+'&com_code='+com_code+'&width='+width;

	if(typeof onchange!='undefined' && onchange>=1)
	{
		url += '&onchange='+onchange+'&file='+file+'&form_name='+form_name+'&oblig='+oblig;				
	}

	var opt = {
			asynchronous: true, 
			evalScripts: true,
			onSuccess: function( t ) { 
				$('targetCommunesBox_'+form_name).innerHTML = t.responseText;
				if(oblig==true)
				{
					eval('document.'+form_name+'.com_code.oblig="true"');
				}
			}
	}
	new Ajax.Request(url, opt);
}

/**
 * Get Adresses List by Comm
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function setCommAdresses(file, form_name, oblig, com_code, adr_code, width)
{
	url = ROOT_HOST+file+'?obj=ajax&action=set_comm_adresses&com_code='+com_code+'&adr_code='+adr_code+'&width='+width;

	var opt = {
			asynchronous: true, 
			evalScripts: true,
			onSuccess: function( t ) { 
				$('targetAdressesBox_'+form_name).innerHTML = t.responseText;
				if(oblig==true)
				{
					eval('document.'+form_name+'.adr_code.oblig="true"');
				}
			}
	} 
	new Ajax.Request(url, opt);
}

/**
 * Delete Multiple Rows
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function deleteMultipleRows(objForm, textMatch)
{
	if(typeof objForm == 'undefined') objForm=document.form_list;
	if(typeof textMatch == 'undefined') textMatch='ids';

	var c=0;
	var items = objForm.elements;
	for(i=0;i<items.length;i++)
	{
		if(items[i].type == 'checkbox' && items[i].name.match(textMatch))
			if(items[i].checked == true)
			{
				c++;
				break;
			}
	}
	if(c >= 1)
	{
		objForm.act.value = 'delete';
		if(confirm(txtConfirmDel))
			objForm.submit();
	}
	else
		alert('No rows set!');
}

/**
 * Edit Row
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function editRow(urlEdit, objForm, textMatch)
{
	if(typeof objForm == 'undefined') objForm=document.form_list;
	if(typeof textMatch == 'undefined') textMatch='ids';

	var c=0; var id=0;
	var items = objForm.elements;
	for(i=0;i<items.length;i++)
	{
		if(items[i].type == 'checkbox' && items[i].name.match(textMatch))
			if(items[i].checked == true)
			{
				c++;
				id=items[i].value;
			}
		if(c>1)
			break;
	}
	if(c==1)
		window.location=urlEdit+id;
	else if(c==0)
		alert('Select the row to edit!');
	else
		alert('Select only a row to edit!');
}


/**
 * Get Communes List by Pay
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function setPrcPbi(file, form_name, prc_code, csl_code)
{
	url = ROOT_HOST+file+'?obj=ajax&action=set_prc_pbi&prc_code='+prc_code+'&csl_code='+csl_code;

	var opt = {
			asynchronous: true, 
			evalScripts: true,
			onSuccess: function( t ) {
				$('targetPBIParamBox_'+form_name).innerHTML = t.responseText;
			},
onFailure: function(r){alert('Erreur lors du chargement des paramtres biologiques :' +r.responseText);}
	}
	new Ajax.Request(url, opt);
}

/**
 * Content menu
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function cMenu(obj_sufix, item_selected, no_items)
{
	for(i=1;i<=no_items;i++)
	{
		if(i==item_selected)
		{
			$(obj_sufix+'btn'+i).className='btn2Sel';
			$(obj_sufix+i).style.display='block';
		}
		else
		{
			$(obj_sufix+'btn'+i).className='btn2';
			$(obj_sufix+i).style.display='none';
		}

	}
}


/**
 * Ajax Medecin Form (case user and non user)
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function setMedecinFormAct(form_type, per_code)
{
	url = ROOT_HOST+'index.php?obj=ajax&action=set_medecin_form_act&form_type='+form_type+'&per_code='+per_code;

	var opt = {
			asynchronous: true, 
			evalScripts: true,
			onSuccess: function( t ) { 
				$('medecinFromAct').innerHTML = t.responseText;

				if(form_type==2)
				{
					document.form_act.spm_code.oblig='true';
					//document.form_act.civ_code.oblig='true';
					document.form_act.per_nom.oblig='true';
					//document.form_act.per_prenom.oblig='true';
					//document.form_act.adr_cp.oblig='true';
					//document.form_act.adr_ville='true';
					//document.form_act.adr_voie.oblig='true';							
					//document.form_act.cer_code.oblig='true';
					document.form_act.per_code.oblig='false';

					//setPayCommunes('index.php', 'form_act', true, document.form_act.pay_code.value, document.form_act.com_code_h.value, 168);	
				}
				else
				{
					$('per_code').oblig='true';

					document.form_act.per_code.oblig='true';
				}
			}
	}
	new Ajax.Updater('medecinFromAct',url, opt);
}

/**
 * Pat Pbi Graph
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function patpbiGraph(pat_per_code, pbi_code)
{
	var id='graph_'+pat_per_code+'_'+pbi_code;

	if (document.getElementById(id))
	{
		posX=document.getElementById(id).offsetLeft;
		posY=document.getElementById(id).offsetTop;
		document.getElementById('pHeader').removeChild(document.getElementById(id));
	}

	var oDiv=document.createElement("div");
	oDiv.style.position='absolute';
	//oDiv.style.left='50%';//parseInt(posX)+'px';
	//oDiv.style.top='50%';//parseInt(posY)+'px';
	oDiv.style.zIndex='2000';
	oDiv.id=id;
	document.onselectstart = function() {return false;}

	var content='<img alt="click to close" title="click to close" onmouseover="this.style.cursor=\'pointer\'" onclick="document.getElementById(\'pHeader\').removeChild(document.getElementById(\''+id+'\'));" src="'+ROOT_HOST+'jpgraph.php?action=patpbi_graph&pat_per_code='+pat_per_code+'&pbi_code='+pbi_code+'" alt="'+pat_per_code+', '+pbi_code+'" />';

	oDiv.innerHTML=content;
	if (!document.getElementById(id)) 
	{
		//document.body.appendChild(oDiv);

		document.getElementById('pHeader').appendChild(oDiv);
	}
}

/**
 * Patient comment update
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function actPatientComment(per_code_pat, pat_com_type, act)
{
	var pat_com_txt=encodeURIComponent($('pat_com_txt'+pat_com_type).value);

	$('pat_com_txt'+pat_com_type).style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST+'index.php?obj=ajax&action=act_patient_comment';

	var opt = { 
			asynchronous: true, 
			evalScripts: true,
			method: 'post',
			postBody: 'act='+act+'&pat_com_txt='+pat_com_txt+'&per_code_pat='+per_code_pat+'&pat_com_type='+pat_com_type, 
			onSuccess: function( t ) 
			{
				$('pat_com_txt'+pat_com_type).style.background='';
				$('pat_com_txt'+pat_com_type).value=t.responseText;
			}
	}
	new Ajax.Request(url, opt);
}


/**
 * Search Medecin
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function searchMedecin(per_code_pat, csl_code)
{
	var per_nom=$('per_nom').value;
	var per_prenom=$('per_prenom').value;
	var spm_code=$('spm_code').value;
	var com_nom=$('com_nom').value;
	var dep_nom=$('dep_nom').value;

	$('medecin_search_result').style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST+'index.php?obj=ajax&action=medecin_search_result&per_code_pat='+per_code_pat+'&csl_code='+csl_code;

	var opt = { 
			asynchronous: true, 
			evalScripts: true,
			method: 'post',
			postBody: 'act=search&per_nom='+per_nom+'&per_prenom='+per_prenom+'&spm_code='+spm_code+'&com_nom='+com_nom+'&dep_nom='+dep_nom, 
			onSuccess: function( t ) 
			{
				$('medecin_search_result').style.background='';
				$('medecin_search_result').innerHTML=t.responseText;
			}
	}
	new Ajax.Request(url, opt);
}

/**
 * Assign Medecin Corespondant
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function medecinCorespondant(per_code_pat, per_code_med, act, csl_code)
{
	$('medecin_corespondant').style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST+'index.php?obj=ajax&action=medecin_corespondant&per_code_med='+per_code_med+'&per_code_pat='+per_code_pat+'&act='+act+'&csl_code='+csl_code;
	var opt = { 
			asynchronous: true, 
			evalScripts: true,		
			onSuccess: function( t ) 
			{
				$('medecin_corespondant').style.background='';
				$('medecin_corespondant').innerHTML=t.responseText;
			}
	}
	new Ajax.Request(url, opt);
}

/**
 * Compte Rendu
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function compteRendu(csl_code,modele_lettre)
{
	$('compte_rendu').style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';

	var url = ROOT_HOST+'index.php?obj=patient&action=compte_rendu&csl_code='+csl_code;

	if(typeof modele_lettre!='undefined' && modele_lettre)
		url+='&modele_lettre='+modele_lettre;

	var opt = { 
			asynchronous: true, 
			evalScripts: true,		
			onSuccess: function( t ) 
			{
				$('compte_rendu').style.background='';
				$('compte_rendu').innerHTML=t.responseText;
			}
	}
	new Ajax.Request(url, opt);
}

/**
 * Print Compte Rendu
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function printCompteRendu(csl_code)
{
	var no_med=$('no_med').value;
	var str_med='';
	for(i=0;i<no_med;i++)
	{
		if($('med'+i).checked==true)
		{
			str_med+=$('med'+i).value+'-'+$('cou_lettre'+i).value+',';
		}		
	}

	if(str_med!='')
	{		
		var url='index.php?obj=patient&action=csl_print&csl_code='+csl_code;

		popup(url, 810, 800, 'csl_print'+csl_code, 1);
	}
	else
		alert('Vous devez choisir au moins un mdecin');
}

/**
 * Save Courrier Edite
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function saveCourrierEdite(csl_code)
{
	var no_med=$('no_med').value;

	var str_med='';
	for(i=0;i<no_med;i++)
	{
		if($('med'+i).checked==true)
		{
			str_med+=$('med'+i).value+'-'+$('cou_lettre'+i).value+',';
		}		
	}

	$('medecin_corespondant').style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST+'index.php?obj=ajax&action=save_courrier_edite&csl_code='+csl_code;

	var opt = { 
			asynchronous: true, 
			evalScripts: true,
			method: 'post',
			postBody: 'act=save&str_med='+str_med, 
			onSuccess: function( t ) 
			{
				$('medecin_corespondant').style.background='';
				$('medecin_corespondant').innerHTML=t.responseText;
				window.location.reload(true);
			}
	}
	new Ajax.Request(url, opt);
}

/**
 * Search Medicament
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function searchPrescription(per_code_pat)
{
	var medi_nom_com=$('medi_nom_com').value;

	$('prescription_search_result').style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST+'index.php?obj=patient&action=prescription_search_result&per_code_pat='+per_code_pat;
	//encoding:'ISO-8859-1',
	var opt = { 
			asynchronous: true, 
			evalScripts: true,
			method: 'post',
			postBody: 'act=search&medi_nom_com='+medi_nom_com, 
			onSuccess: function( t ) 
			{
				$('prescription_search_result').style.background='';
				$('prescription_search_result').innerHTML=t.responseText;
			}
	}
	new Ajax.Updater('prescription_search_result', url, opt);
}


/**
 * Search Medicament
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function traitementFormAdd(act)
{

	var str_post='act2='+act;
	var value;
	var form = document.form_act;	
	for(var j = form.elements.length-1; j >= 0; j--)
	{
		if (form.elements[j].type=="checkbox")
		{
			if(form.elements[j].checked)
				value=1;
			else
				value=0;
		}
		else
			value = form.elements[j].value;

		str_post+='&'+form.elements[j].name+'='+value;
	}

	$('table_form_act').style.background='url('+ROOT_HOST+'img/useful/ajax_indicator.gif) no-repeat center center';	

	url = ROOT_HOST+'index.php?obj=patient&action=traitement_form_add';	

	var opt = { 
			asynchronous: true, 
			evalScripts: true,
			method: 'post',
			postBody: str_post ,
			onSuccess: function( t ) 
			{
				$('table_form_act').style.background='';
				$('table_form_act').innerHTML=t.responseText;

				nor=document.form_act.no_pre.value;
				for(i=0;i<=nor;i++)
				{				
					$('pre_quantite'+i).format='float';
					$('pre_duree'+i).format='integer';
					$('pre_renouvel'+i).format='integer';		
				}
			}
	}
	new Ajax.Updater('table_form_act',url, opt);
}

var CslBrowser = Class.create();
CslBrowser.prototype = {
		initialize: function(opt) {
			this.wrapper = opt.cont;
			this.no = opt.no;
			this.csl_current = 0;
			this.pagination = opt.pagination;
		},

		browse: function(csl_id) {
			if (csl_id<0 || csl_id>=this.no) return;

			this.csl_hide_all();
			this.csl_show(csl_id)
			$(this.pagination).update((this.csl_current+1)+" sur "+this.no);
		},

		csl_hide_all: function() {

			for (var i = 0; i < this.no; i++)
				$(this.wrapper+i).hide()
		},

		csl_show: function(csl_id) {
			$(this.wrapper+csl_id).show()
			this.csl_current = csl_id
		},

		browse_last: function() {
			this.browse(this.no-1);
		}

}

function clairanceSet(age, sexe)
{
	//DFG = 175  [(cratininmie en mol/l)/88,4]-1,154  (ge)-0,203  (0,742 si femme)
	//ca n'apparait pas trs bien mais (-1,154) et (-0,203) sont des exposants

	if ($('pbi_creatinine') != null)
	{
		creatinine = $('pbi_creatinine').value;
		if (creatinine!="")
			clairance = 175 * Math.pow(creatinine/88.4,-1.154) * Math.pow(age,-0.203);
		else
			clairance = "";

		if (sexe == 2)
			clairance = clairance * 0.742;
	}
	else
		clairance = "";

	if (clairance != "")
		clairance = Math.round(clairance);

	if (clairance==0)
		clairance = "";


	if ($('pbi_clairance') != null)
		$('pbi_clairance').value = clairance
}

function cslUnsaveTest()
{
	if (cslUnsave !=2 && typeof(FCKeditorAPI)!=='undefined')
	{
		var oEditor = FCKeditorAPI.GetInstance('csl_comment');

		if (oEditor.IsDirty()==true){ cslUnsave=1;}
		if (cslUnsave==1) {
			setWaitPage(false);
			return "Vous avez effecu des changements sans sauvegarder, si vous ne sauvegardez pas ceux ci seront perdus.";
		};
	}
}

function cslResetDirty()
{
	if (typeof(FCKeditorAPI)!=='undefined')
	{
		var oEditor = FCKeditorAPI.GetInstance('csl_comment');
		//alert(oEditor.IsDirty());

		oEditor.ResetIsDirty();
		//alert(oEditor.IsDirty());
	}
}

function chargeOnglet(name,per_code,gre_code,action)
{
	//alert("chargeonglet");
	//on affecte dans str_post les informations qui seront passs au controleur pour traitement
	var str_post = 'gre_code='+gre_code;
	//variable qui contient le formaulaire de saisi
	var form = "";
	//variable qui contient le nom du formulaire selectionner (vivant ou decede), permet au controleur de savoir si c'est un update ou un add
	var saveForm="";
	//variable qui contient l'url de traitement
	var url = ROOT_HOST+'index.php?obj=greffe&action='+name+'&per_code='+per_code;
	// variable qui permet de faire l'appel ajax
	var traitement=true;
	
	//si l'action est diffrent de add alors c'est que le donneur existe et on recupre les informations du formulaire pour modification
	//sinon on affiche seulement le template (formulaire vide) correspondant au donneur
	if (action!='add'){
		
		var onglet='';
		var change=false;
		if (saveForm=='form_greffe_greffe'){
			onglet="de l'onglet greffe";
		} else {
			onglet="de l'onglet donneur";
		}
		
		change=confirm('Voulez-vous sauvegarder les informations '+onglet+'?');
		
		if (change==true){
			//alert("chargeonglet form_name="+document.getElementById("form_onglet").name);
			//si l'onglet en cours est le formulaire donneur
			if (document.getElementById("form_onglet").name=="form_greffe_donneur"){
				//cas du formulaire donneur
				//si le type de donneur est renseign
				if (document.getElementById("don_type").value!=''){
					//on recupere le formulaire
					form=document.form_greffe_donneur;
					//affecte la valeur correspondant au formulaire donneur pour maj
					saveForm="form_greffe_donneur";
				} else {
					// on affecte la variable a faux pour ne pas faire l'appel ajax
					traitement=false;
					alert('Veuillez selectionner le type de donneur.');
					setWaitPage(false);
				}
			}else{
				//sinon c'est le formulaire greffe
				//on recupere le formulaire
				form=document.form_greffe_greffe;
				//affecte la valeur correspondant au formulaire greffe pour maj
				saveForm="form_greffe_greffe";
			}
			
			if (traitement){
				for(var j = form.elements.length-1; j >= 0; j--)
				{
					if (form.elements[j].type=="selected")
					{
						liste = form.elements[j];
						value = liste.options[liste.selectedIndex].text;
					}
					else{
						value = form.elements[j].value;
					}
	
					str_post+='&'+form.elements[j].name+'='+value;
				}
			}
		}
		
	}
		
	//concateine le nom du formaulaire pour traitement dans le controleur
	url+='&saveForm='+saveForm;
	
	if (traitement){
		//alert ("url = "+url);
		//on effectue l'appel ajax
		new Ajax.Request(url,{
			method: 'post',
				parameters: str_post,
				asynchronous: true, 
				onSuccess: function(response){
				//alert('ok chargement onglet ' + response.responseText);
				$('consulte_don_gref').innerHTML='';
				$('consulte_don_gref').innerHTML=response.responseText;
					setWaitPage(false);
					},
				onFailure:function(){
					console.log('echec');
					$('consulte_don_gref').innerHTML="echec de l'affichage de l'onglet "+name;
					setWaitPage(false);
			}
		});
		
	}
}

function displayInfoDonneur(value,per_code)
{
	//alert('dans displayInfoDonneur');
	var type_donneur="";
	var typeDonneur_existant="";
	var type="";
	//var newType=true;
	var change=true;
	
	var gre_code = document.getElementById("gre_code").value;
	//recupere le type de donneur
	if (value=="0"){
		type_donneur="greffe_donneur_vivant";
	}
	else{
		type_donneur="greffe_donneur_decede";
	}
	
	typeDonneur_existant=document.getElementById("typeDonneur_existant").value;
	//alert('typeDonneur existant est '+typeDonneur_existant);
	if ((typeDonneur_existant!='') && (value!=typeDonneur_existant)){
		//newType=true;
		change=confirm('Voulez-vous modifier le type de donneur?\n (Les modification seront effectives lors de la sauvegarde.)');
		if (change == false) {
			document.getElementById("don_type").value=typeDonneur_existant;
			setWaitPage(false);
		} else {
			// si le type de donneur exisant est un type decede et que le nouveau type  de donneur est aussi un type decede	
			// c'est le meme formulaire on ne le recharge pas
			if (((value==1) || (value==2)) && ((typeDonneur_existant==1) || (typeDonneur_existant==2))){
				change=false;
				setWaitPage(false);
			}
		}
	}
	
	if (type_donneur!=="" && change){
	//if (type_donneur!==""){
		var url=ROOT_HOST+'index.php?obj=greffe&action='+type_donneur+'&per_code='+per_code;
		console.log('avant requte!');
		new Ajax.Request(url,{
				method: 'post',
				parameters: 'gre_code='+gre_code+'&typeDonneur='+value,
				asynchronous: true, 
				onSuccess: function(response) {
					console.log('sucess!');
					//alert('ok chargement type donneur');
					$('consulte_donneur').innerHTML='';
					$('consulte_donneur').innerHTML=response.responseText;
					setWaitPage(false);
				},
				onFailure:function(){
					console.log('Erreur!');
					setWaitPage(false);
					$('consulte_donneur').innerHTML="echec de l'affichage du formulaire "+type_donneur;
				}
		});
	}
}

function ajouterLigne(url,txtAdd,txtDel,gre_code,per_code)
{
	//alert('gre_code = '+gre_code+' url='+url);
	var ligne = document.getElementById("tab_immuno").getElementsByTagName("tr").length;
	var id = ligne;
	
	var urlAjax=ROOT_HOST+'index.php?obj=greffe&action=ajoutConditionImminoSupp&per_code='+per_code;
	new Ajax.Request(urlAjax,{
		method: 'post',
		parameters :'gre_code='+gre_code+'&url='+url+'&txtDel='+txtDel+'&txtAdd='+txtAdd+'&ligne='+ligne,
		asynchronous: true, 
		onSuccess: function(response) {
			//alert('rep ajouterligne '+response.responseText);
			var newLigne = document.getElementById("tab_immuno").insertRow(-1); // cration d'une ligne pour ajout en fin de table
		    // le paramtre est dans ce cas (-1)
			//newLigne.setAttribute("id",id);
			newLigne.innerHTML=response.responseText;
			document.getElementById("tab_immuno").rows[id-1].cells[2].innerHTML='';
			setWaitPage(false);
		},
		onFailure:function(){
			setWaitPage(false);
			alert("echec de la cration de la greffe");
		}
	});
}

function supLigne(obj,url,txtAdd,txtDel,gre_code,per_code){
	var id=obj.parentNode.parentNode.rowIndex;
	//alert('id a sup '+id);
	var avant = document.getElementById("tab_immuno").getElementsByTagName('tr').length;
	//alert("supLigne nbligne avant"+avant);
	document.getElementById("tab_immuno").deleteRow(id);
	var ligne = document.getElementById("tab_immuno").getElementsByTagName('tr').length;
	//alert("supLigne nbligne restant"+ligne);
	document.getElementById("tab_immuno").rows[ligne-1].cells[2].innerHTML='<td style="width:10px;"><img src="'+url+'admin/add.gif" border="0" alt="'+txtAdd+'" onclick="ajouterLigne(\''+url+'\',\''+txtAdd+'\',\''+txtDel+'\',\''+gre_code+'\',\''+per_code+'\');"/></td>';
}

function creationGreffe(per_code,action){
	//alert('action '+action);
	//rcupre la valeur des champs
	var date_greffe=$('gre_date').value.trim();
	var rang_greffe=$('gre_rang').value.trim();
	var greffon_fonctionnel=$('gre_greffon_fonct').value.trim();
	var date_fin_fonction=$('gre_date_fin_fnc').value.trim();
	var cause_fin_fonction=$('ffg_code').value.trim();
	//variable qui indique si on peut faire l'appel ajax pour crer la greffe
	var creation_ok=false;
	
	//test si le champs date greffe, rang greffe et greffon fonctionnelle sont renseign
	if (date_greffe.length && rang_greffe.length && greffon_fonctionnel.length){
		//si greffon fct  la valeur oui alors on peut crer la greffe
		if (greffon_fonctionnel=='1'){
			creation_ok=true;
		} else {
			//sinon pour la valeur non, il faut tester si les champs date fin fonction et cause_fin_fonction sont renseigns
			if (date_fin_fonction.length && cause_fin_fonction.length){
				creation_ok=true;
			} else {
				setWaitPage(false);
				alert('Les champs \'Date fin de fonction\' et \'Cause\' doivent tre renseigns.');
			}
				
		}
	}else{
		setWaitPage(false);
		alert('Les champs \'Date de greffe\', \'Rang de greffe\' et \'Greffon fonctionnel\' doivent tre renseigns.');
	}
	
	//on fait l'appel ajax pour creer la date si creation_ok=true
	if (creation_ok){
		var url=ROOT_HOST+'index.php?obj=greffe&action=creer_greffe&per_code='+per_code;
		new Ajax.Request(url,{
				method: 'post',
				parameters : 'gre_date='+date_greffe+'&gre_rang='+rang_greffe+'&gre_greffon_fonct='+greffon_fonctionnel+'&gre_date_fin_fnc='+date_fin_fonction+'&ffg_code='+cause_fin_fonction,
				asynchronous: true, 
				onSuccess: function(response) {
					//alert('ok response.responseText '+response.responseText);
					//setWaitPage(false);
					var gre_code = response.responseText.trim();
					//on recupre id de la greffe crer
					document.getElementById("gre_code").value=gre_code;
					//on insere les onglets Donneur et La greffe  la place de creer greffe
					//alert("ok response.responseText action="+action);
					//document.getElementById("info_greffe").rows[2].cells[0].innerHTML='<td colspan="2"><button name="bt_donneur"  onclick="setWaitPage(true);chargeOnglet(\'onglet_donneur\','+per_code+','+gre_code+',\'add_upd\');">DONNEUR</button></td>';
					document.getElementById("info_greffe").rows[3].cells[0].innerHTML='<div name="bt_donneur" id="bt_donneur" class="btn1" style="width: 100px; margin-top: 7px;"><div><a	onclick="setWaitPage(true);chargeOnglet(\'onglet_donneur\','+per_code+','+gre_code+',\'add_upd\');">DONNEUR</a><div></div>';
					//document.getElementById("info_greffe").rows[2].cells[1].innerHTML='<td colspan="2"><button name="bt_greffe"  onclick="setWaitPage(true);chargeOnglet(\'onglet_greffe\','+per_code+','+gre_code+',\'add_upd\');">LA GREFFE</button></td>';
					document.getElementById("info_greffe").rows[3].cells[1].innerHTML='<div name="bt_greffe" id="bt_greffe" class="btn1" style="width: 100px; margin-top: 7px;"><div><a onclick="setWaitPage(true);chargeOnglet(\'onglet_greffe\','+per_code+','+gre_code+',\'add_upd\');">LA GREFFE</a></div></div>';
					document.getElementById("info_greffe").rows[3].cells[2].innerHTML='<div id="valide_greffe" name="valide_greffe" class="btn1" style="width: 100px; margin-top: 7px;"><div><a onclick="setWaitPage(true);sauve_greffe();">Sauvegarder</a></div></div>';
									
					//on charge le formulaire donneur par default avec le parametre action = add
					chargeOnglet('onglet_donneur',per_code,gre_code,'add');
					//on modifie l'opacit de la page pour signaler la fin du traitement
					setWaitPage(false);
				},
				onFailure:function(){
					setWaitPage(false);
					alert("echec de la cration de la greffe");
				}
		});
		/*document.getElementById("info_greffe").rows[2].cells[0].innerHTML='<td colspan="2"><button name="bt_donneur"  onclick="setWaitPage(true);chargeOnglet(\'page_upd_donneur\','+per_code+');">DONNEUR</button></td>';
		document.getElementById("info_greffe").rows[2].cells[1].innerHTML='<td colspan="2"><button name="bt_greffe"  onclick="setWaitPage(true);chargeOnglet(\'page_upd_greffe\','+per_code+');">LA GREFFE</button></td>';*/
	}
}

function sauve_onglet(onglet,per_code){
	var gre_code=document.getElementById("gre_code").value;
	//alert('sauve_greffe gre_code ='+gre_code);
	var url=ROOT_HOST+'index.php?obj=greffe&action=sauvegarde_onglet&onglet='+onglet+'&per_code='+per_code+'&gre_code='+gre_code;
	var onglet_save = "";
	var change = false;
	var form ="";
	//alert('url '+url);
	
	if (onglet=='onglet_greffe'){
		form=document.form_greffe_greffe;
		onglet_save="de l'onglet greffe";
	} else {
		form=document.form_greffe_donneur;
		onglet_save="de l'onglet donneur";
	}
	
	change=confirm('Voulez-vous sauvegarder les informations '+onglet_save+'?');
	
	//alert ("url = "+url);
	if (change!=false){
		form.action=url;
		form.submit();
		setWaitPage(false);
	} else {
		setWaitPage(false);
	}
}

function consulte_greffe(gre_code){
	var url=ROOT_HOST+'index.php?obj=greffe&action=consulte_greffe&gre_code='+gre_code;
	newwindow=window.open(url,'Consultation greffe','height=500,width=800,scrollbars=yes,resizable=yes');
	setWaitPage(false);
}

function sauve_greffe(){
	var gre_code=document.getElementById("gre_code").value;
	var str_post = 'gre_code='+gre_code;
	var url=ROOT_HOST+'index.php?obj=greffe&action=sauve_greffe';
	var form=document.form_greffe;
	var change=false;
	
	change=change=confirm('Voulez-vous sauvegarder les informations obligatoires  la cration de la greffe ?');
	
	if (change){
		for(var j = form.elements.length-1; j >= 0; j--)
		{
			if (form.elements[j].type=="selected")
			{
				liste = form.elements[j];
				value = liste.options[liste.selectedIndex].text;
			}
			else{
				value = form.elements[j].value;
			}
	
			str_post+='&'+form.elements[j].name+'='+value;
		}
		
		new Ajax.Request(url,{
			method: 'post',
			parameters : str_post,
			asynchronous: true, 
			onSuccess: function(response) {
				setWaitPage(false);
			},
			onFailure:function(){
				setWaitPage(false);
				alert("Echec de la sauvegarde de la modification de la greffe");
			}
		});
	}
	
}

function afficheInfoRepNo(value){
	if (value=='2'){
		document.getElementById('date_fin_fnc').style.display = 'table-row';
		document.getElementById('cause').style.display = 'table-row';
	} else {
		document.getElementById('date_fin_fnc').style.display = 'none';
		document.getElementById('cause').style.display = 'none';
	}
	
}

function isPositifNumber(element,typeNumber){
	var value=0;
	
	if (typeNumber=='entier'){
		value=parseInt(element.value);
	}
	
	if (typeNumber=='float'){
		value=parseFloat(element.value);
	}
	
	if (value<0){
		alert("Le nombre saisie doit tre positif");
		element.focus();
	}
}

function calculImcDov(){
	var poids="",
	var taille="";
	try{
		if ((document.getElementById('don_poids').value==null) || (document.getElementById('don_poids').value=='')) return;
		poids=document.getElementById('don_poids').value;
		
		if ((document.getElementById('don_taille').value==null) || (document.getElementById('don_taille').value=='')) return;
		taille=document.getElementById('don_taille').value;
		
		if(checkNumber(poids) && checkNumber(poids)) {
			document.getElementById('dov_imc').value=new Number(poids/(taille*taille)).toFixed(2);
		}
	}
	catch(err){
		alert("Une erreur est survenue lors du calcul IMC du donneur vivant : "+e.message);
	}
}

function calculClairanceDov(){
	var creatine"";
	var age="";
	var sexe="";
	try{
		
		if ((document.getElementById('dov_creat').value==null) || (document.getElementById('dov_creat').value=='')) return;
		creatine=document.getElementById('dov_creat').value.replace(",", ".");
		if ((document.getElementById('don_age').value==null) || (document.getElementById('don_age').value=='')) return;
		age=document.getElementById('don_age').value;
		if ((document.getElementById('don_sexe').value==null) || (document.getElementById('don_sexe').value=='')) return;
		sexe=document.getElementById('don_sexe').value;
		
		if (checkNumber(creatine) && (sexe=='1')){
			document.getElementById('dov_clair_calc').value=new Number(186*pow((creatine*0.0113),-1.154)*pow(age,-0.203)).toFixed(2);
		}
		if (checkNumber(creatine) && (sexe=='2')){
			document.getElementById('dov_clair_calc').value=new Number(186*pow((creatine*0.0113),-1.154)*pow(age,-0.203)*0.742).toFixed(2);
		}
	}
	catch(e){
		alert("Une erreur est survenue lors du calcul de la Clairance du donneur vivant : "+e.message);
	}
}

function afficheDodBandeau(value){
	if (value=='1'){
		document.getElementById('dod_bandeau').setAttribute('disabled';false);
	} else {
		document.getElementById('dod_bandeau').setAttribute('disabled';true);
	}
}

function calculeDod_Dfg(){
	var creatine"";
	var age="";
	var sexe="";
	try{
		
		if ((document.getElementById('don_creat_arrivee').value==null) || (document.getElementById('don_creat_arrivee').value=='')) return;
		creatine=document.getElementById('don_creat_arrivee').value.replace(",", ".");
		if ((document.getElementById('don_age').value==null) || (document.getElementById('don_age').value=='')) return;
		age=document.getElementById('don_age').value;
		if ((document.getElementById('don_sexe').value==null) || (document.getElementById('don_sexe').value=='')) return;
		sexe=document.getElementById('don_sexe').value;
		
		if (checkNumber(creatine) && (sexe=='1')){
			document.getElementById('dov_clair_calc').value=new Number(175*pow((creatine/88.4),-1.154)*pow(age,-0.203));
		}
		if (checkNumber(creatine) && (sexe=='2')){
			document.getElementById('dov_clair_calc').value=new Number(175*pow((creatine/88.4),-1.154)*pow(age,-0.203)*0.742);
		}
	}
	catch(e){
		alert("Une erreur est survenue lors du calcul de la DFG du donneur dcde : "+e.message);
	}
}

/*function verifHeure($value){
	//expression regulire pour un format heure (hh:mm) sur 24h
	var exp=new RegExp("^([01]?[0-9]|2[0-3]):[0-5][0-9]$","g");
	  if ( !exp.test($value) ) {
		  alert("Le format de l'heure est hh:mm."); 
	  }
	 
}*/
